#ifndef _SUMMARYDATA_H_DEFINED
#define _SUMMARYDATA_H_DEFINED

#include "ShortReadGenotype.h"

struct SummaryData {
	double	nucsTotal[5];
	double	nucsUnvoided[5];
	double	nucsPartial[5];
	double	nucsEffective[5];
	double	genoCounts[ 10 ];
	double	dataLogLikelihood;
	double	pileupLinesRead;
	double	pileupLinesSkipped;
	double  pileupLinesProcessed;
	double	callerLinesProcessed;
	double  callerLinesVoided;
	double	callerLinesSNP;
	double	callerLinesnSNP;
	SummaryData() {
		for( int i=0; i<5; i++) {
			nucsTotal[i] = nucsUnvoided[i] = nucsPartial[i] = nucsEffective[i] = genoCounts[i] = genoCounts[i+5] = 0.0; };
		dataLogLikelihood = 0.0; 
		pileupLinesRead = pileupLinesSkipped = pileupLinesProcessed = 0.0;
		callerLinesProcessed = callerLinesVoided = callerLinesSNP = callerLinesnSNP = 0.0;
	};

	bool	Dump( FILE *f, const ShortReadGenotype &Caller ) const {
		int		i;
		double	sum;
		double	nuc_partial;

		fprintf( f, "\n\n# SUMMARY DATA\n");
		fprintf( f, "Pileup - Lines Read - Tot : %15.0f\n",pileupLinesRead);
		fprintf( f, "Pileup - Lines Skipped    : %15.0f\n",pileupLinesSkipped);	// indels
		fprintf( f, "Pileup - Lines Processed  : %15.0f\n",pileupLinesProcessed);	// data, but all of 0 quality
		fprintf( f, "Caller - Lines Processed  : %15.0f\n",callerLinesProcessed);
		fprintf( f, "Caller - Lines Voided     : %15.0f\n",callerLinesVoided);
		fprintf( f, "Caller - Lines Assessed   : %15.0f\n",callerLinesProcessed-callerLinesVoided);
		fprintf( f, "Caller - SNPs  called     : %15.0f\n",callerLinesSNP);
		fprintf( f, "Caller - nSNPs called     : %15.0f\n",callerLinesnSNP-callerLinesVoided);
		fprintf( f, "Caller - nSNPs from Void  : %15.0f\n",callerLinesVoided);
		fprintf( f, "\n");

		// Total
		for (sum = 0.0, i=0; i<5;i++) {
			fprintf( f, "Nucs - Total - %c          : %20.0f\n", Caller.HapName(i).c_str()[0] ,nucsTotal[i]); sum += nucsTotal[i]; }
		fprintf( f, "Nucs - Total - Sum        : %20.0f\n\n", sum );

		// Unvoided
		for (sum = 0.0, i=0; i<5;i++) {
			fprintf( f, "Nucs - Unvoided - %c       : %20.0f\n", Caller.HapName(i).c_str()[0] ,nucsUnvoided[i]); sum += nucsUnvoided[i]; };
		fprintf( f, "Nucs - Unvoided - Sum     : %20.0f\n\n", sum );

		// Partial
		for (sum = 0.0, i=0; i<5;i++) {
			fprintf( f, "Nucs - Partial - %c        : %20.4f\n", Caller.HapName(i).c_str()[0] ,nucsPartial[i]); sum += nucsPartial[i]; };
		fprintf( f, "Nucs - Partial - Sum      : %20.4f\n\n", sum );
		nuc_partial = sum;

		// Effective
		for (sum = 0.0, i=0; i<5;i++) {
			fprintf( f, "Nucs - Effective - %c      : %20.4f\n", Caller.HapName(i).c_str()[0] ,nucsEffective[i]); sum += nucsEffective[i]; };
		fprintf( f, "Nucs - Effective - Sum    : %20.4f\n\n", sum );

		for (sum = 0.0, i=0; i<10;i++) {
			fprintf( f, "Geno - Counts - %s            : %20.4f\n", Caller.DipName(i).c_str() ,genoCounts[i]); sum += genoCounts[i]; };
		fprintf( f, "Geno - Counts - Sum           : %20.4f\n\n", sum );

		fprintf( f, "Data NLL10 - Total            : %20.4f\n\n", dataLogLikelihood );
		if (nuc_partial > 0.0) {
			fprintf( f, "Data NLL10 - PerNuc           : %20.10f\n\n", dataLogLikelihood/ nuc_partial);
		};

		return( true );
	};
};

#endif 
