#pragma once

#ifndef _PILEUPREADER_H_DEFINED
#define _PILEUPREADER_H_DEFINED

#include <stdio.h>

#include <string>
using std::string;

class PileupReader
{
private:
	typedef unsigned long ulong;
	string			_fileName;
	FILE			*_fin;
	ulong			_allLineCount;		// all lines, validor not.
	ulong			_lineCount;			// Number of data lines read
	bool			_lineValid;			// is currently buffered line valid?
	long			_stringBufSize;		// min size of string buffers
	char			*_nucsRead;			// String buffers
	char			*_nucsQuality;
	char			*_alignQuality;
	char			*_readBuffer;		// Extra long strign buffer
	string			_seqName;			// Name of chromosome
	ulong			_seqPos;			// Position in Chrosome
	char			_refBase;			// Symbol for reference base at this position
	char			_concensusBase;		// CConsencus as called by pileup
	long			_concensusQuality;	// COnsensuys Quality as called by pileup
	long			_snpQuality;		// SNP quality
	long			_maxMappingQuality;	// 
	long			_numReads;			// Number of bases symbols at this location in the pileup (includes "*" and "N")
	long			_numReadsTrimmed;	// Number of invalid bases trimmed by TrimInvalid
	double			_debug_LinesRead;		// for debuggign purposes
	double			_debug_LinesDiscarded;
	//
	bool		EnforceBufferCapacity( long NewSize );		// reallocate all buffersd
	bool		ProcessNucsRead( char *ReadBuffer );		//
	bool		ProcessNucsQuality( char *ReadBuffer );
	bool		ProcessAlignQuality( char *ReadBuffer );
	void		MyAbort();	// Deal with critical local error before exitingfor debuggign purposes
public:
	PileupReader(void);
	virtual ~PileupReader(void);
	bool IsFileOpen( void ) const						{ return( _fin != NULL); };
	bool FileOpen( const string &FileName );
	bool FileClose( );
	bool FetchNextLine( bool &HitEof );
	unsigned long TrimInvalid( double *NumTrimmed );
	string	FileName( void )			const	{ return( _fileName ); };
	bool LineValid()					const	{ return(_lineValid ); };
	ulong CurrentLineNumber()			const	{ return(_lineCount); };		// Line numbers start at 1, so a 0 here means nothing has been read.
	// Get The Current Column in the Pileup
	string	ReferenceSegmentName(void)	const	{ return( _seqName );  };
	ulong	ReferenceSegmentPos(void)	const	{ return( _seqPos );   };
	long	NumReads( void )			const	{ return( _numReads ); };
	long	NumReadsTrimmed( void )		const	{ return( _numReadsTrimmed ); };
	char	GetReferenceBase( void )	const	{ return( _refBase );  };
	bool	GetMAQCalls( char &ConcensusCharacter, long &ConcensusQuality, long &SnpQuality, long &RmsMapQuality )	const;
	void	GetBases( string &ShortReads, string &ShortReadQual, string &ShortReadAlnQual, char &ReferenceRead )	const;
	bool	GetBase( long Index, char &Base, char &BaseQuality, char &BaseSeqQuality ) // TODO it may pay to speed this up, get rid if index checkign and take a char * ....
			{	if (Index<0) return(false); if (Index>=_numReads) return( false);
				Base = _nucsRead[Index]; BaseQuality=_nucsQuality[Index]; BaseSeqQuality = _alignQuality[Index];
				return( true ); };
	bool	PrintLine( FILE *Fout ) const;
	double	D_LinesRead() const		{ return(_debug_LinesRead) ; };
	double	D_LinesSkipped() const	{ return(_debug_LinesDiscarded); };
	int		BaseToIndex( char C )	{ switch( toupper(C) ) { case 'A': return( 0 ); case 'C' : return( 1 ); case 'G' : return( 2 ); case 'T': return( 3 ); } return( 4); };
};

#endif 
