#ifndef _NONSNPBUFFER_H_DEFINED
#define _NONSNPBUFFER_H_DEFINED

#include <stdio.h>
#include<stdlib.h>

// In trder to provide a terse output, only minimal statistics are provided for positions that have
//		are a high confidence match to the refrence genome. Only the depth and quality are provide, one
//		character each. These are aggregated in a buffer and printed on a singel line one a stream
//		of matching reads comes to an end at a SNP, the end of a chromosome, or a gap in coverage.

struct NonSNPBuffer {
private:
	string	startNameChr;		// Current chromosome name
	string	numReads;			// number of positive-quality reads at each location
	string	probHomo;			// PHRED style probability that the read is NOT homo for reference genome
	long	startChrPos;		// start location (1 based) of this sequence of matches in the current chromosome
	long	lastChrPos;			// latest match
	double  d_num_buffered;		
	double  d_num_written;		// maintained for debugging.
public:
	NonSNPBuffer()				{ d_num_buffered=0.0; d_num_written = 0.0; Clear(); };
	void	Clear()				{ startNameChr=""; numReads=""; probHomo=""; startChrPos=-1;  return; };
	bool	IsEmpty() const		{ return(startChrPos==-1); };
	double	D_NumBuff() const	{ return( d_num_buffered ); };
	double	D_NumWrites() const	{ return( d_num_written ); };
	double  D_NumTot() const    { return( d_num_written + numReads.length() ); };
	bool	Gather( FILE *fout, const string &ChrName, long ChrPos, long NumValidReads, double ProbSNP ) {
		long num_reads; long q_snp; bool ok;
		d_num_buffered++;
		if ( (!IsEmpty()) && ((ChrName!=startNameChr) || (lastChrPos+1!=ChrPos) ) ) {
			ok = Flush(fout); if (!ok) return( false); }
		if (IsEmpty()) { startNameChr = ChrName; startChrPos = ChrPos; };
		num_reads = NumValidReads + '!'; if (num_reads > '~') num_reads = '~'; 
		numReads.push_back( (char) num_reads );
		if (ProbSNP == 0.0) {
			q_snp = '~';
		} else {
			double lg_prob = log10(ProbSNP);
			if (lg_prob > 0.0) lg_prob = 0.0;
			q_snp = '!' + (long) ceil( -5 * lg_prob );	// thsi gives us a range from 1.0 to 10^-18
		};
		if (q_snp > (long) '~') q_snp = (long)'~';
		probHomo.push_back( (char) q_snp);
		lastChrPos = ChrPos;
		return( true ); 
	};
	bool Flush( FILE *fout ) {
		long ok; 
		if (IsEmpty()) return( true );
		d_num_written += numReads.length();
		ok = fprintf(fout,"%s %10ld %10ld ",startNameChr.c_str(),startChrPos,numReads.length());
		if (ok<1) {
			//return( false );
			fprintf(stderr,"NSMP.Flush Failed 1- Exiting\n"); exit(-100); }
		ok = fprintf(fout,"%s %s\n",numReads.c_str(), probHomo.c_str() );
		if (ok<1 ) {
			 // return( false );
			fprintf(stderr,"NSMP.Flush Failed 2- Exiting\n"); exit(-100); }
		Clear(); 
		return( true );
	};
};

#endif 
