#pragma once

#include <math.h>


class LogProb {
typedef double BaseType;
private:
	const static double _baseMin;
	const static double	_log10factor;	//	= (1.0) / (LOG( 10.0 ) );
	const static double	_log2factor;	//	= (1.0) / (LOG( 2.0 ) );
	const static double	_logEfactor;	//	= (1.0) / (LOG( 2.0 ) );
	BaseType		_baseValue;
protected:
	// Define the base for this class, may be changed ifa mroe efficent (say base 2) version becomes available
	const static double	_myBase;	//				= 10.0;
	//
	static	double	LOG( const double &X )		{ double tmp = log10( X ); tmp = (tmp < LogProb::_baseMin ? LogProb::_baseMin : tmp); return( tmp ); };
	static	double	EXP( const double &X )		{ if (X<=LogProb::_baseMin) return( 0.0); return( pow( _myBase, X ) ); };
	//
	BaseType		BaseValue() const				{ return( _baseValue ); };
	void			SetBaseVal( const BaseType &X )	{ _baseValue = X; return; };
	//
	
public:
	// constructors
	LogProb( void )								{ _baseValue = (BaseType) 0.0;  };					// the same in all bases log(prob = 1.0 ) = 0.0
	LogProb( const LogProb &X )					{ _baseValue = X.BaseValue(); };
	LogProb( const double &X )					{ _baseValue = (BaseType) LogProb::LOG( (double) X ); };
	//
	virtual ~LogProb(void)						{ _baseValue = 0.0; };								// Clear before deallocation...
	//
	double	Log10() const							{ return( _baseValue * LogProb::_log10factor ); };
	double	Log2() const 							{ return( _baseValue * LogProb::_log2factor ); };
	double	LogE() const 							{ return( _baseValue * LogProb::_logEfactor ); };
	void	Pow( const double &Exponent )			{ _baseValue *= Exponent; return; };
	//void	Pow( const LogProb &Exponent )			{ _baseValue = LogProb::EXP( LogProb::LOG(_baseValue)+Exponent.BaseValue() ); return; };	// Using a little Algebra...
	operator double() const							{ return( (double) LogProb::EXP( _baseValue )); };
	//operator float() const							{ return( (float)  LogProb::EXP( _baseValue )); };
	void		operator*=( const LogProb &Param )	{ if ((_baseValue==_baseMin) || (Param.BaseValue()==_baseMin)) _baseValue=_baseMin; else _baseValue += Param.BaseValue(); return; };
	void		operator*=( const double &Param )	{ _baseValue += (LogProb) Param; return; };
	void		operator/=( const LogProb &Param )	{ _baseValue -= Param.BaseValue(); };
	void		operator/=( const double &Param )	{ _baseValue -= LogProb::LOG( Param ); };
	void		operator+=( const LogProb &Param );
	void		operator+=( const double  &Param );
	bool		operator>( const LogProb &Param )	{ return( BaseValue() > Param.BaseValue() ); };
	bool		operator>( const double &Param )	{ return( (*this) > (LogProb) Param ); };

	//
	friend LogProb operator *( const double &Param2,  const LogProb &Param1);
	friend LogProb operator *( const LogProb &Param1, const double &Param2);
	friend LogProb operator *( const LogProb &Param1, const LogProb &Param2);

	friend LogProb operator +( const double &Param2,  const LogProb &Param1);
	friend LogProb operator +( const LogProb &Param1, const double &Param2);
	friend LogProb operator +( const LogProb &Param1, const LogProb &Param2);
	//

	friend LogProb operator /( const double &Param2,  const LogProb &Param1);
	friend LogProb operator /( const LogProb &Param1, const double &Param2);
	friend LogProb operator /( const LogProb &Param1, const LogProb &Param2);
	//
	// gcc compatibility problems
	// friend static double logadd( const double &X, const double &Y);
	friend double logadd( const double &X, const double &Y);
};





 
