//#include "stdafx.h"

#include "LogProb.h"

#define _USE_MATH_DEFINES
#include "math.h"	// log, pow, M_E

#include "float.h"

const double LogProb::_log10factor	= (1.0) / (LOG( 10.0 ) );
const double LogProb::_log2factor	= (1.0) / (LOG( 2.0 ) ); 
const double LogProb::_logEfactor	= (1.0) / (LOG( M_E ) ); 
const double LogProb::_myBase		= 10.0; //				= 10.0;
const double LogProb::_baseMin		= -DBL_MAX; //				= 10.0;
/*
static const LogProb::_log10factor	= (1.0) / (LOG( 10.0 ) );
static const LogProb::_log2factor	= (1.0) / (LOG( 2.0 ) ); 
static const double	_myBase			= 10.0; //				= 10.0;
*/

// g++ compatibility poblems
// static double logadd(const double &X, const double &Y);
double logadd(const double &X, const double &Y);

LogProb operator *( const double &Param2, const LogProb &Param1) {
	return( Param1 * Param2 );	// Invoke fucntion below...
}

LogProb operator *( const LogProb &Param1, const double &Param2) {
	LogProb	temp( Param2 );
	temp *= Param1;
	return( temp );
}

LogProb operator *( const LogProb &Param1,  const LogProb &Param2) {
	LogProb temp(Param1);
	temp *= Param2;
	return( temp );
}

LogProb operator /( const double &Param2, const LogProb &Param1) {
	LogProb temp(Param2);
	temp /= Param1;
	return(  temp );	// Invoke fucntion below...
}

LogProb operator /( const LogProb &Param1, const double &Param2) {
	LogProb	temp1(Param1), temp2( Param2 );
	temp1 /= temp2;
	return( temp1 );
}

LogProb operator /( const LogProb &Param1,  const LogProb &Param2) {
	LogProb temp(Param1);
	temp /= Param2;
	return( temp );
}

LogProb operator +( const double &Param2, const LogProb &Param1) {
	return( Param1 + Param2 );	// Invoke fucntion below...
}

LogProb operator +( const LogProb &Param1, const double &Param2) {
	LogProb	temp( Param2 );
	temp += Param1;
	return( temp );
}

LogProb operator +( const LogProb &Param1,  const LogProb &Param2) {
	LogProb temp(Param1);
	temp += Param2;
	return( temp );
}

void LogProb::operator +=( const double &Param ) {
	double temp;
	temp = logadd( this->_baseValue, LogProb::LOG(Param) );
	this->_baseValue = temp;
	//return( *this );
	return;
}

void LogProb::operator +=( const LogProb &Param ) {
	double temp;
	temp = logadd( this->_baseValue, Param.BaseValue() );
	this->_baseValue = temp;
	// return( *this );
	return;
}

// g++ has trouble with this
//static double logadd( const double &X, const double &Y) {
double logadd( const double &X, const double &Y) {
	// return( LOG( EXP(X) + EXP(Y) ) );
	register double x_v, y_v, delta;

	if (Y>X) {
		x_v = Y; y_v = X;
	}else {
		x_v = X; y_v = Y; };

	// if we are here then xv >= yv
	if (x_v <= LogProb::_baseMin) return( LogProb::_baseMin );	// 0+0 = 0
	if (y_v <= LogProb::_baseMin) return( x_v );				// X+0 = X

	// otherwise....
	delta = x_v - y_v;
	if (delta > (DBL_DIG+3) ) return(x_v);				// Ignore tiny numbers.. see float.h
	return(x_v+LogProb::LOG(1.0+LogProb::EXP(-delta)));
}

 
