#ifndef _INPUTARGS_H_DEFINED
#define _INPUTARGS_H_DEFINED

#include<stdlib.h>

// MLE fit of parameters to all high quality reads (MAQ quality >= 100)
//	over 8 subjects provides (based on 7.73 billion genotype calls).
//
//	p0		= 0.00079357
//	kappa	= 3.9365
//	phi		= 0.40435

struct InputArgs {
	string	fileNameIn;				// Input FileName or - or ""
	string	fileNameOut;			// Output file name or "-" or ""
	string	fileNameOutNS;			// Output file name for non_SNP info, if selected, or "-" or ""
	string	fileNameOutSum;			// output file name for summary info like priors etc...
	string	fileNameCustPrior;		// file containing fully custom genotype priors.
	double	phi;					// phi = about 0.4092139 ratio of cg / (cg+at)
	double	kappa;					// Transversion vs transition bias. Pub Vals run from 2.7 to > 9. Typical seems around 3.78,
	double	p0;						// base chance of being hetrozygote (about 1 in 1000 can vary by population 0.75e-3 not uncommon)
	double	minBSNPprob;			// Mon posterior prob of non-canonical to be considred a SNP, generally 1% or .1%
	double	theta;					// Factor to use to Degrade Correlated Errors (0-1.0, 1.0 disables).
	double  thetaMin;				// Minimum possible Theta (0-1.0, 0 disabbles cutoff, 1.0 disables Correlated Error Compensation)
	long	minMAQsnpQ;				// Min SNP Q score to be considered a MAQ SNP, generally  1 (the smallest non 0 value) which corresponds to 20% chance of SNP.
	bool	ignoreInvalidBases;		// Bases that have alignment  =0 or, base call Q = 0 or Base Call letter outsideof ACGT are considered invalid
	bool	verbose;				// print stauts messages to stderr.
	bool	debugging;				// dump debugging info...
	bool	dumpNonSNPs;			// dump minimal info about each location that is not a SNP candidate.
	bool	dumpSharedInfo;			// Dumpo Shared Statistical Info like Priors, HG18 Probs etc...
	bool	invertTheta;			// by default, penalize highest quality errors least. Otherwise, invert.. and penalize highest wuality errors the most.
	bool	printBSNPCall;			// add a a column for 1 character representation of most likely posterior genotype.
	int		sequencingTech;			// 0 = UNKNOWN, 1 = Illumina, 2 = Sanger, 3 = 454, 4 = SOLiD (converted to Nuc Space)

	// constructor / initialize
	InputArgs() {
		fileNameIn			= "-";			// stdin
		fileNameOut			= "-";			// stdout
		fileNameOutNS		= "-";			// stdout.... (send to stderr?)
		fileNameOutSum		= "-";			// stdout...
		fileNameCustPrior	= "";			// null string means use default priors model
//		phi					= 0.40435;		// phi = about 0.4092139 ratio of cg / (cg+at).
		phi					= 0.5;			// Adam requested noninformative prior as default.
//		kappa				= 3.9365;		// Transversion vs transition bias. Pub Vals run from 2.7 to > 9. Typical seems around 3.78.
		kappa				= 1.0000;		// Adam requested noninformative prior as default.
//		p0					= 7.9357e-4;	// base chance of 79/100,000 of being hetrozygote
		p0					= 0.0010;		// Adam requested the conservative value of 10 in 10,000 as the default
		minMAQsnpQ			= 1;			// Smallest non 0 probability of being a SNP
		minBSNPprob			= .001;			// .1% chance of SNP is good enough to keep
		theta				= 0.85;			// The value used by MAQ.
		thetaMin			= 0.00;			// Suggested by Adam, for final run.
		ignoreInvalidBases	= true;		
		verbose				= false;		// print periodic status numbers to stderr indicating progress.
		debugging           = false;
		dumpNonSNPs			= true;
		dumpSharedInfo		= true;
		invertTheta			= false;		// true - sort ascending (ala SOAP), false = sort in order of descending quality (ala MAQ)
		printBSNPCall		= true;			// easily inferred from psoterior, but convienent to have in output file.
		sequencingTech		= 0;			// default to 00 = UNKNOWN, assume errors are uniformly distributed.
		return; }

	// Interpret input arguments
	bool ParseArgs( int ArgC, char *ArgV[] ) {
		int		arg_no = 1;
		string	arg;

		if (ArgC == 1) return( false );	// just print arg lsit and return
		while (arg_no < ArgC ) {
			arg = ArgV[ arg_no ]; arg_no++;
			if (arg == "-i" ) {
				if ( arg_no >= ArgC ) return( false );
				fileNameIn	= ArgV[arg_no]; arg_no++;
			} else if (arg == "-ip" ) {
				if ( arg_no >= ArgC ) return( false );
				fileNameCustPrior = ArgV[arg_no]; arg_no++;
			} else if (arg == "-o" ) {
				if ( arg_no >= ArgC ) return( false );
				fileNameOut	= ArgV[arg_no]; arg_no++;
			} else if (arg == "-on" ) {
				if ( arg_no >= ArgC ) return( false );
				fileNameOutNS	= ArgV[arg_no]; arg_no++;
			} else if (arg == "-os" ) {
				if ( arg_no >= ArgC ) return( false );
				fileNameOutSum= ArgV[arg_no]; arg_no++;
			} else if (arg == "-ph" ) {
				if ( arg_no >= ArgC ) return( false );
				phi				= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-ka" ) {
				if ( arg_no >= ArgC ) return( false );
				kappa			= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-p0" ) {
				if ( arg_no >= ArgC ) return( false );
				p0				= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-th" ) {
				if ( arg_no >= ArgC ) return( false );
				theta			= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-tm" ) {
				if ( arg_no >= ArgC ) return( false );
				thetaMin		= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-mq" ) {
				if ( arg_no >= ArgC ) return( false );
				minMAQsnpQ	= atoi(ArgV[arg_no]); arg_no++;
			} else if (arg == "-st" ) {			// Sequencing technology 0 = UNKNOWN, 1 = Illumina, 2 = Sanger, 3 = 454, 4 = SOLiD (converted to Nuc Space)
				if ( arg_no >= ArgC ) return( false );
				sequencingTech		= atoi(ArgV[arg_no]); arg_no++;
				if ( (sequencingTech < 0) || (sequencingTech > 4)) return( false );
			} else if (arg == "-mp" ) {
				if ( arg_no >= ArgC ) return( false );
				minBSNPprob	= atof(ArgV[arg_no]); arg_no++;
			} else if (arg == "-ns" ) {
				if ( arg_no >= ArgC ) return( false );
				dumpNonSNPs	= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-si" ) {
				if ( arg_no >= ArgC ) return( false );
				dumpSharedInfo		= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-ig" ) {
				if ( arg_no >= ArgC ) return( false );
				ignoreInvalidBases	= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-v" ) {
				if ( arg_no >= ArgC ) return( false );
				verbose				= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-d" ) {
				if ( arg_no >= ArgC ) return( false );
				debugging				= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-pb" ) {
				if ( arg_no >= ArgC ) return( false );
				printBSNPCall			= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else if (arg == "-ti" ) {	// thata Invert
				if ( arg_no >= ArgC ) return( false );
				invertTheta			= ( atoi(ArgV[arg_no]) !=0 ); arg_no++;
			} else {
				return( false ); }
		}; // end while

		return( true );
	}

};

#endif 
